	function h = MAX_FLAT_FIR(Zm1, Z)
 
	% 	Computes the impulse response of an FIR filter of type I or II
	% 	with Zm1 zeros at z = -1 and 2Z zeros at z  -1.
	% 	Filter order N = Zm1 + 2Z
	%	Half-band filter for Zm1 = 2Z + 2
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2010-11-15
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1		 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	h = 1;	a = 1;	b = 1;
	for n = 1:Z
		a = conv(a,[-1 2 -1]/4);
		b = b*(Zm1/2-1+n)/n;
		h = [0 h 0] + b*a;
	end
	for n = 1:Zm1
		h = conv(h,[1 1]/2);
	end
